/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.util;

import com.andavin.reflect.Reflection;
import com.andavin.reflect.exception.UncheckedClassNotFoundException;
import org.bukkit.Bukkit;

public enum MinecraftVersion {
    v1_7,
    v1_8,
    v1_9,
    v1_10,
    v1_11,
    v1_12,
    v1_13,
    v1_14,
    v1_15,
    v1_16,
    v1_17,
    v1_18,
    v1_19;

    public static final MinecraftVersion CURRENT;
    public static final String MINECRAFT_PREFIX;
    public static final String CRAFTBUKKIT_PREFIX;
    private static final String FULL_VERSION;

    public static boolean is(MinecraftVersion version) {
        return CURRENT == version;
    }

    public static boolean lessThan(MinecraftVersion version) {
        return CURRENT.ordinal() < version.ordinal();
    }

    public static boolean greaterThan(MinecraftVersion version) {
        return CURRENT.ordinal() > version.ordinal();
    }

    public static boolean greaterThanOrEqual(MinecraftVersion version) {
        return CURRENT.ordinal() >= version.ordinal();
    }

    public static Class<?> findMcClass(String name) throws UncheckedClassNotFoundException {
        return Reflection.findClass(MINECRAFT_PREFIX + name);
    }

    public static Class<?> findCraftClass(String name) throws UncheckedClassNotFoundException {
        return Reflection.findClass(CRAFTBUKKIT_PREFIX + name);
    }

    public String toString() {
        return FULL_VERSION;
    }

    static {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        String versionString = name.substring("org.bukkit.craftbukkit.".length(), name.lastIndexOf("_R"));
        try {
            CURRENT = MinecraftVersion.valueOf(versionString);
        }
        catch (RuntimeException e) {
            throw new UnsupportedOperationException("Version " + versionString + " is not supported.", e);
        }
        MINECRAFT_PREFIX = "net.minecraft.server." + (Object)((Object)CURRENT) + '.';
        CRAFTBUKKIT_PREFIX = "org.bukkit.craftbukkit." + (Object)((Object)CURRENT) + '.';
        FULL_VERSION = CURRENT.name() + '_' + (Object)((Object)MinorVersion.CURRENT);
    }

    public static enum MinorVersion {
        R1,
        R2,
        R3,
        R4,
        R5;

        public static final MinorVersion CURRENT;

        static {
            String name = Bukkit.getServer().getClass().getPackage().getName();
            String versionString = name.substring(name.indexOf(82));
            try {
                CURRENT = MinorVersion.valueOf(versionString);
            }
            catch (RuntimeException e) {
                throw new UnsupportedOperationException("Minor version " + versionString + " is not supported.", e);
            }
        }
    }
}

